// ToolForm.cs
//
// This file implements the Form window that is the
// user interface for the simple Tool plug-in that this
// project creates. The Form contains two buttons. One button
// disables all LA modules in the system. The other enables
// all LA modules
/////////////////////////////////////////////////////////////

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Tektronix.LogicAnalyzer.TpiNet;

namespace CSharpSamplePlugIn
{
	/// <summary>
	/// Summary description for ToolForm.
	/// </summary>

    // To ensure the best interaction with the TLA user interface,
    // this class is derived from TlaForm.
	public class ToolForm : System.Windows.Forms.Form
	{
        private System.Windows.Forms.Button enableLAsButton;
        
        private ITlaPlugInSupport plugInSupport = null;
		private System.Windows.Forms.Button disableLAsButton;
        
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ToolForm(ITlaPlugInSupport supportObject)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			plugInSupport = supportObject;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ToolForm));
			this.enableLAsButton = new System.Windows.Forms.Button();
			this.disableLAsButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// enableLAsButton
			// 
			this.enableLAsButton.Location = new System.Drawing.Point(56, 104);
			this.enableLAsButton.Name = "enableLAsButton";
			this.enableLAsButton.Size = new System.Drawing.Size(224, 40);
			this.enableLAsButton.TabIndex = 0;
			this.enableLAsButton.Text = "Enable All LA Modules";
			this.enableLAsButton.Click += new System.EventHandler(this.enableLAsButton_Click);
			// 
			// disableLAsButton
			// 
			this.disableLAsButton.Location = new System.Drawing.Point(56, 32);
			this.disableLAsButton.Name = "disableLAsButton";
			this.disableLAsButton.Size = new System.Drawing.Size(224, 40);
			this.disableLAsButton.TabIndex = 1;
			this.disableLAsButton.Text = "Disable All LA Modules";
			this.disableLAsButton.Click += new System.EventHandler(this.disableLAsButton_Click);
			// 
			// ToolForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(336, 176);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.disableLAsButton,
																		  this.enableLAsButton});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "ToolForm";
			this.Text = "Example Tool Plug-In";
			this.ResumeLayout(false);

		}
		#endregion

		// Disables all LA modules in the system in response to
		// user pressing the disableLAsButton button.
		private void disableLAsButton_Click(object sender, System.EventArgs e) 
		{
            SetLAsEnabledState(false);
        }

		// Enables all LA modules in the system in response to
		// user pressing the enableLAsButton button.
		private void enableLAsButton_Click(object sender, System.EventArgs e) 
		{
            SetLAsEnabledState(true);
        }
        
		// This utility method uses the cached ITlaPlugInSupport object
		// to find all LA modules and set their enabled state.
        private void SetLAsEnabledState (bool enabledState) 
		{
			if (null != plugInSupport) {
				// The ITlaSystem.DataSources property contains a list
				// of all data sources in the system
				ArrayList dataSources = plugInSupport.System.DataSources;
				
				// Search through the list for ILAModule instances
				// and changed their enabled state.
				for (int index = 0; index < dataSources.Count; ++index) 
				{
                    if (dataSources[index] is ILAModule) {
                        ILAModule laModule = (ILAModule) dataSources[index];
                        laModule.IsEnabled = enabledState;
                    }
                }
            }
        }
	}
}
